﻿<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zestawienie do nagrody jubileuszowej</title>
		<script runat="server">


            public class PrnParams : ContextBase {
                
                public PrnParams(Context context) : base(context) {
                    definicja = KadryModule.GetInstance(context).DefPodstawStazu.Zatrudnienie;
                    okres = new YearMonth(((ActualDate)context[typeof(ActualDate)]).Actual).ToFromTo();
                }

                FromTo okres;
                [Caption("Raport za okres")]
                [Priority(10)]
                [Required]
                public FromTo Okres {
                    get { return okres; }
                    set {
                        okres = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                DefPodstawyStazu definicja;
                [Caption("Podstawa stażu")]
                [Priority(20)]
                public DefPodstawyStazu Definicja {
                    get { return definicja; }
                    set {
                        definicja = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                int wymaganyStaż;
                [Caption("Wymagany staż pracy")]
                [Priority(30)]
                [Required]
                public int WymaganyStaż {
                    get { return wymaganyStaż; }
                    set {
                        wymaganyStaż = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

            }

            PrnParams pars;
            [Context]
            public PrnParams Params {
                set { pars = value; }
            }
		    
       void OnContextLoad(Object sender, EventArgs args) {
           YearMonth ym = new YearMonth(pars.Okres.From);
           ReportHeader1["OKRES"] = pars.Okres==ym.ToFromTo() ? ym.ToString() : pars.Okres.ToString();
           ReportHeader1["PODSTAWA"] = pars.Definicja==null ? "" : pars.Definicja.ToString();
           ReportHeader1["STAŻ"] = pars.WymaganyStaż.ToString();

           granica = new StazPracy(pars.WymaganyStaż, 0, 0);
       }

            StazPracy granica;

            void Grid1_BeforeRow(Object sender, RowEventArgs args) {
                Pracownik p = (Pracownik)args.Row;

                Periods okresy = Periods.Empty;
                foreach (PracHistoria ph in p.Historia.GetIntersectedRows(pars.Okres))
                    okresy += ph.Etat.EfektywnyOkres;
                okresy = (okresy * pars.Okres).ToFlat();

                Date data = Date.Empty;

                foreach (FromTo okres in okresy) {
                    //Limit przekroczony w poprzednim miesiącu
                    StazPracy poprzedni = p.StażPracy(okres.From-1, pars.Definicja);
                    if (poprzedni>=granica)
                        continue;

                    foreach (Date dataStażu in okres) {
                        StazPracy staż = p.StażPracy(dataStażu, pars.Definicja);
                        if (staż>=granica) {
                            data = dataStażu;
                            break;
                        }
                    }
                }

                if (data != Date.Empty)
                    colData.EditValue = data;
                else
                    args.VisibleRow = false;
            }

            void Msg(object value) {
            }        

		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="ZestawienieDoNagrodyJubileuszowej" method="post" runat="server">
			<EA:DATACONTEXT id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Business.Row[], Soneta.Business"></EA:DATACONTEXT>
			<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Zestawienie do nagrody jubileuszowej|</strong>Za okres: <strong>%OKRES%|</strong>Uwzględnij podstawę: <strong>%PODSTAWA%|</strong>Wymagany staż: <strong>%STAŻ%" runat="server"></cc1:reportheader>
			<EA:GRID id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" RowTypeName="Soneta.Kadry.Pracownik,Soneta.KadryPlace">
				<Columns>
					<ea:GridColumn Caption="LP." DataMember="#" Align="Right" Width="4" runat="server"></ea:GridColumn>
                    <ea:GridColumn runat="server" DataMember="Pracownik">
                    </ea:GridColumn>
                    <ea:GridColumn ID="colData" runat="server" Caption="Data wypracowania stażu" Align="Center" Width="25">
                    </ea:GridColumn>
				</Columns>
			</EA:GRID>
			<cc1:reportfooter id="ReportFooter1" runat="server"></cc1:reportfooter>
		</form>
	</body>
</HTML>
